/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config;

import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemAuthor;
import frc.emul.config.data.CfgItemGame;
import frc.emul.config.data.CfgItemGameContainer;
import frc.emul.config.data.CfgItemGameInfo;
import frc.emul.util.Utils;
import frc.emul.util.swing.AALabel;
import frc.emul.util.swing.DialogWindow;
import frc.emul.util.swing.FrameWindow;
import frc.emul.util.swing.IWindow;
import frc.emul.vectrex.swing.UIGameBuilder;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.Browser;
import frc.emul.vectrex.ui.config.UIUtils;
import frc.emul.version.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;

public class UIGameSelector {
    private GamesComboBox combo;
    private CfgItemGame selected;
    private JPanel infoPane;
    private boolean fullscreen;
    private boolean debugMode;
    private String cartridge;
    private JLabel lblAuthor;
    private JLabel lblVersion;
    private JLabel lblDate;
    private JLabel lblAuthorURL;
    private JLabel lblDoc;
    private JLabel lblRomSize;
    private JLabel lblRomCRC;
    private Map<JComponent, JComponent> labels = new HashMap<JComponent, JComponent>();

    public void configChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CfgItemGame chooseGame(final JFrame jFrame, final Configuration configuration, final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("This method must not be called from the EDT");
        }
        final Object object = new Object();
        Runnable runnable = new Runnable(){

            public void run() {
                Window window = UIGameSelector.this.createSelectorWindow(jFrame, configuration, bl).getWindow();
                window.addWindowListener(new WindowAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void windowClosed(WindowEvent windowEvent) {
                        Object object2 = object;
                        synchronized (object2) {
                            object.notifyAll();
                        }
                    }
                });
                window.setVisible(true);
            }
        };
        Object object2 = object;
        synchronized (object2) {
            SwingUtilities.invokeLater(runnable);
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {}
            return this.selected;
        }
    }

    private IWindow createSelectorWindow(JFrame jFrame, final Configuration configuration, boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("This method must be called from the EDT");
        }
        this.fullscreen = configuration.options.display_fullscreen;
        this.debugMode = configuration.isDebugMode();
        this.cartridge = null;
        this.selected = null;
        String string = !bl ? "ParaJVE - Select a game to switch to..." : (Version.isBetaVersion() ? "ParaJVE - Private Preview - Please do not share!  :-)" : "ParaJVE v" + Version.sSHORT + " - Game selection");
        final IWindow iWindow = bl ? new FrameWindow(string) : new DialogWindow(jFrame, string, true);
        final Window window = iWindow.getWindow();
        final JButton jButton = new JButton();
        JButton jButton2 = new JButton("Pick another ROM...");
        JButton jButton3 = new JButton("Assemble SOURCE...");
        JButton jButton4 = new JButton("Cancel");
        jButton3.setToolTipText("Select the source file that will be used to build the ROM to execute");
        jButton2.setToolTipText("Select another ROM image to execute");
        if (!Utils.isWindowsOS()) {
            jButton3.setEnabled(false);
            jButton3.setToolTipText("Feature not available on this platform...");
        }
        JCheckBox jCheckBox = new JCheckBox("Fullscreen mode", this.fullscreen);
        jCheckBox.setHorizontalAlignment(0);
        if (!window.getGraphicsConfiguration().getDevice().isFullScreenSupported()) {
            jCheckBox.setText("Fullscreen (fallback)");
            jCheckBox.setToolTipText(" FullScreen mode does not appear to be supported by the Graphics Device, we will try and emulate this feature. ");
        } else {
            jCheckBox.setToolTipText("Check this box to run the selected ROM in FullScreen mode.");
        }
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIGameSelector.this.fullscreen = ((JCheckBox)actionEvent.getSource()).isSelected();
                UIGameSelector.this.configChanged();
            }
        });
        if (!bl) {
            jCheckBox.setEnabled(false);
            jCheckBox.setToolTipText("The FullScreen state cannot be changed when the emulator is started.");
        }
        this.combo = new GamesComboBox();
        this.combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                CfgItemGame cfgItemGame = UIGameSelector.this.combo.getSelectedGame();
                String string2 = cfgItemGame == null ? "Invalid Selection" : (string = cfgItemGame.cartridge.built ? "<html><center>Build ROM and<br>&nbsp;&nbsp;&nbsp;<b>Run Game</b>&nbsp;&nbsp;&nbsp;</center></html>" : "<html><center>&nbsp;&nbsp;&nbsp;<b>Run Game</b>&nbsp;&nbsp;&nbsp;</center><html>");
                if (!string.equals(jButton.getText())) {
                    jButton.setText(string);
                }
                jButton.setEnabled(cfgItemGame != null);
            }
        });
        this.updateComboContent(configuration);
        this.combo.setSelectedGame(configuration.getSelectedGame());
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                iWindow.getGlassPane().setEnabled(false);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UIGameSelector.this.selected = UIGameSelector.this.accept(window);
                        if (UIGameSelector.this.selected != null) {
                            window.dispose();
                        }
                    }
                });
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CfgItemGame cfgItemGame = UIGameSelector.this.pickGame(window, configuration);
                if (cfgItemGame != null) {
                    UIGameSelector.this.updateComboContent(configuration);
                    UIGameSelector.this.combo.setSelectedGame(cfgItemGame);
                    UIGameSelector.this.configChanged();
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CfgItemGame cfgItemGame = UIGameSelector.this.buildROM(window, configuration);
                if (cfgItemGame != null) {
                    UIGameSelector.this.updateComboContent(configuration);
                    UIGameSelector.this.combo.setSelectedGame(cfgItemGame);
                    UIGameSelector.this.configChanged();
                }
            }
        });
        UIUtils.registerEscapeButton(jButton4, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIGameSelector.this.selected = null;
                window.dispose();
            }
        });
        this.labels.clear();
        this.infoPane = this.buildInfoPane();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.attach(jPanel, jButton, 0, 0, 1, 2);
        this.attach(jPanel, jButton3, 1, 0, 1, 1);
        this.attach(jPanel, jCheckBox, 2, 0, 1, 1);
        this.attach(jPanel, jButton2, 1, 1, 1, 1);
        this.attach(jPanel, jButton4, 2, 1, 1, 1);
        Container container = iWindow.getContentPane();
        container.setLayout(new BorderLayout(10, 5));
        container.add((Component)this.combo, "North");
        container.add((Component)this.infoPane, "Center");
        container.add((Component)jPanel, "South");
        UIUtils.setContainerBorder(container);
        iWindow.getRootPane().setDefaultButton(jButton);
        window.pack();
        Dimension dimension = window.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        dimension.width += 50;
        window.setBounds(dimension2.width - dimension.width >> 1, (dimension2.height - dimension.height) / 2 - dimension.height / 5, dimension.width, dimension.height);
        iWindow.setResizable(false);
        this.combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIGameSelector.this.updateInfo();
            }
        });
        this.updateInfo();
        iWindow.setDefaultCloseOperation(2);
        iWindow.setIconImage(UIUtils.getFrameIcon());
        return iWindow;
    }

    private CfgItemGame accept(Component component) {
        CfgItemGame cfgItemGame = this.combo.getSelectedGame();
        if (cfgItemGame == null) {
            return null;
        }
        String string = cfgItemGame.cartridge.getCartridgePath();
        if (cfgItemGame.cartridge.built) {
            UIGameBuilder uIGameBuilder = new UIGameBuilder();
            File file = uIGameBuilder.buildGame(component, string);
            if (file == null) {
                return null;
            }
            string = file.getPath();
        }
        this.cartridge = string;
        return cfgItemGame;
    }

    private void updateComboContent(Configuration configuration) {
        CfgItemGameContainer[] cfgItemGameContainerArray = configuration.games.toArray(new CfgItemGameContainer[configuration.games.size()]);
        this.combo.setModel(new DefaultComboBoxModel<CfgItemGameContainer>(cfgItemGameContainerArray));
    }

    private final void attach(JPanel jPanel, JComponent jComponent, int n, int n2, int n3, int n4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, n2 + n4 < 2 ? 5 : 0, n < 2 ? 5 : 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
    }

    private CfgItemGame pickGame(Window window, Configuration configuration) {
        CfgItemGame cfgItemGame = configuration.getPickedGame();
        String string = cfgItemGame == null ? "" : cfgItemGame.cartridge.getCartridgePath();
        JFileChooser jFileChooser = new JFileChooser(string);
        if (!"".equals(string)) {
            jFileChooser.setSelectedFile(new File(string));
        }
        jFileChooser.setApproveButtonText("Select ROM");
        jFileChooser.setDialogTitle("Select the ROM to run...");
        UIGameSelector.addVectrexRomFileFilters(jFileChooser);
        if (jFileChooser.showOpenDialog(window) != 0) {
            return null;
        }
        string = jFileChooser.getSelectedFile().getPath();
        try {
            string = jFileChooser.getSelectedFile().getCanonicalPath();
        }
        catch (Exception exception) {}
        return configuration.createUserPickedGame(string);
    }

    private CfgItemGame buildROM(Window window, Configuration configuration) {
        CfgItemGame cfgItemGame = configuration.getBuiltGame();
        String string = cfgItemGame == null ? "" : cfgItemGame.cartridge.getCartridgePath();
        JFileChooser jFileChooser = new JFileChooser(string);
        if (!"".equals(string)) {
            jFileChooser.setSelectedFile(new File(string));
        }
        jFileChooser.setApproveButtonText("Select Source");
        jFileChooser.setDialogTitle("Select the main source for the ROM to run...");
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return !file.isFile() || UIGameSelector.isRomSourceFileName(file);
            }

            public String getDescription() {
                return "*.asm *.s *.a09";
            }
        });
        if (jFileChooser.showOpenDialog(window) != 0) {
            return null;
        }
        string = jFileChooser.getSelectedFile().getPath();
        try {
            string = jFileChooser.getSelectedFile().getCanonicalPath();
        }
        catch (Exception exception) {}
        return configuration.createUserBuiltGame(string);
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public String getCartridgePath() {
        return this.cartridge;
    }

    private final JPanel buildInfoPane() {
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 10, 0), new CompoundBorder(Borders.BEVEL_LOW, new EmptyBorder(7, 8, 5, 0))));
        this.lblAuthor = this.addInfo(jPanel, "Game's Author");
        this.lblAuthorURL = this.addInfo(jPanel, "Author Site");
        this.lblVersion = this.addInfo(jPanel, "Version");
        this.lblDate = this.addInfo(jPanel, "Release Date");
        this.lblDoc = this.addInfo(jPanel, "Documentation");
        this.lblRomSize = this.addInfo(jPanel, "ROM Size");
        if (this.debugMode) {
            this.lblRomCRC = this.addInfo(jPanel, "ROM CRC-32");
        }
        this.lblAuthorURL.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed() && mouseEvent.getModifiers() == 16) {
                    CfgItemAuthor cfgItemAuthor;
                    mouseEvent.consume();
                    CfgItemGame cfgItemGame = UIGameSelector.this.combo.getSelectedGame();
                    CfgItemGameInfo cfgItemGameInfo = cfgItemGame == null ? null : cfgItemGame.info;
                    CfgItemAuthor cfgItemAuthor2 = cfgItemAuthor = cfgItemGameInfo == null ? null : cfgItemGameInfo.author;
                    if (cfgItemAuthor != null && cfgItemAuthor.url != null) {
                        Browser.displayURL(cfgItemAuthor.url, true);
                    }
                }
            }
        });
        this.lblDoc.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed() && mouseEvent.getModifiers() == 16) {
                    mouseEvent.consume();
                    CfgItemGame cfgItemGame = UIGameSelector.this.combo.getSelectedGame();
                    if (cfgItemGame != null && cfgItemGame.isDocAvailable()) {
                        Browser.displayURL(cfgItemGame.getDocURL().toExternalForm(), true);
                    }
                }
            }
        });
        int n = this.labels.size();
        UIUtils.makeCompactGrid(jPanel, n, 2, 0, 0, 6, 4);
        return jPanel;
    }

    private final JLabel addInfo(JPanel jPanel, String string) {
        AALabel aALabel = new AALabel(" " + string + " : ");
        AALabel aALabel2 = new AALabel("");
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        this.labels.put(aALabel2, aALabel);
        jPanel2.add((Component)aALabel2, "West");
        aALabel.setFont(aALabel.getFont().deriveFont(1));
        jPanel.add(aALabel);
        jPanel.add(jPanel2);
        return aALabel2;
    }

    private final void updateInfo() {
        String string;
        CfgItemGame cfgItemGame = this.combo.getSelectedGame();
        CfgItemGameInfo cfgItemGameInfo = cfgItemGame == null ? null : cfgItemGame.info;
        CfgItemAuthor cfgItemAuthor = cfgItemGameInfo == null ? null : cfgItemGameInfo.author;
        String string2 = string = cfgItemAuthor == null ? null : cfgItemAuthor.url;
        String string3 = cfgItemGameInfo == null ? null : (cfgItemGameInfo.date != null ? cfgItemGameInfo.date : this.extractDate(cfgItemGame));
        String string4 = cfgItemGameInfo == null ? null : cfgItemGameInfo.version;
        String string5 = cfgItemGameInfo == null ? null : cfgItemGameInfo.docPath;
        String string6 = cfgItemGameInfo == null ? null : this.formatFileSize(cfgItemGame, cfgItemGameInfo.getBinarySize());
        String string7 = null;
        if (this.debugMode && cfgItemGameInfo != null) {
            long l = cfgItemGameInfo.getBinaryCRC32();
            if (l > -1L) {
                string7 = " " + Utils.HEX(8, (int)l);
            } else if (l < -1L) {
                string7 = "<html><font color=RED> File reading error!";
            }
        }
        this.setInfo(this.lblAuthor, cfgItemAuthor == null ? " ---" : " " + cfgItemAuthor.name);
        this.setInfo(this.lblAuthorURL, UIGameSelector.parseMultipleUrls(string, this.lblAuthorURL));
        this.setInfo(this.lblDate, string3 == null ? " ---" : " " + string3);
        this.setInfo(this.lblVersion, string4 == null ? " ---" : " " + string4);
        this.setInfo(this.lblDoc, string5 == null ? " ---" : "<html>&nbsp;<a href=a>" + string5 + "</a></html>");
        this.setInfo(this.lblRomSize, string6 == null ? " ---" : string6);
        if (this.debugMode) {
            this.setInfo(this.lblRomCRC, string7 == null ? " ---" : string7);
        }
        this.lblDoc.setToolTipText(string == null ? null : "Click to open the game's documentation in a browser");
    }

    private final void setInfo(JLabel jLabel, String string) {
        boolean bl = !string.trim().equals("---");
        jLabel.setText(string);
        jLabel.setEnabled(bl);
        this.labels.get(jLabel).setEnabled(bl);
        jLabel.setCursor(string.startsWith("<html>") ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
    }

    private static final String parseMultipleUrls(String string, JLabel jLabel) {
        if (string == null) {
            jLabel.setToolTipText(null);
            return "---";
        }
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("<html>&nbsp;");
        int n = 0;
        int n2 = string.indexOf("##");
        if (n2 < 0) {
            jLabel.setToolTipText("<html>Click to browse the author's site (<font color=#0000FF>" + string + "</font>)");
            stringBuilder.append("<a href=a>").append(Utils.stripURL(string)).append("</a>");
        } else {
            jLabel.setToolTipText("Click the links to browse the authors sites...");
            while (n2 >= 0) {
                stringBuilder.append("<a href=a>").append(Utils.stripURL(string.substring(n, n2))).append("</a>&nbsp;&nbsp;and&nbsp;&nbsp;");
                n = n2 + 2;
                n2 = string.indexOf("##", n);
            }
            stringBuilder.append("<a href=a>").append(Utils.stripURL(string.substring(n))).append("</a>");
        }
        return stringBuilder.append("</html>").toString();
    }

    private final String formatFileSize(CfgItemGame cfgItemGame, int n) {
        if (n <= 0) {
            return null;
        }
        if ((n & 0x3FF) == 0) {
            return " " + (n >> 10) + " Kb";
        }
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        NumberFormat numberFormat2 = NumberFormat.getNumberInstance();
        numberFormat2.setMinimumIntegerDigits(1);
        numberFormat2.setMinimumFractionDigits(1);
        numberFormat2.setMaximumFractionDigits(1);
        String string = numberFormat2.format((float)n / 1024.0f);
        if (string.endsWith(",0")) {
            string = string.substring(0, string.length() - 2);
        }
        return " " + string + " Kb  (" + numberFormat.format(n) + " bytes)";
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String extractDate(CfgItemGame cfgItemGame) {
        InputStream inputStream;
        block12: {
            inputStream = null;
            inputStream = cfgItemGame.getCartridgeStream().open();
            inputStream.skip(6L);
            byte[] byArray = new byte[]{(byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read(), (byte)inputStream.read()};
            int n = Integer.parseInt(new String(byArray));
            if (n < 1980 || n >= 2100) break block12;
            String string = Integer.toString(n);
            if (inputStream == null) return string;
            try {
                inputStream.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
            catch (Throwable throwable) {
                try {
                    if (inputStream == null) return null;
                }
                catch (Throwable throwable2) {
                    if (inputStream == null) throw throwable2;
                    try {
                        inputStream.close();
                        throw throwable2;
                    }
                    catch (IOException iOException) {}
                    throw throwable2;
                }
                try {
                    inputStream.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        if (inputStream == null) return null;
        try {
            inputStream.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    public static final FileFilter addVectrexRomFileFilters(JFileChooser jFileChooser) {
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return !file.isFile() || UIGameSelector.isRomFileName(file);
            }

            public String getDescription() {
                return "Usual ROM file names (*.bin *.img *.rom *.vec *.jverom)";
            }
        });
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return !file.isFile() || UIGameSelector.isRomFile(file);
            }

            public String getDescription() {
                return "Vectrex ROM files";
            }
        };
        jFileChooser.addChoosableFileFilter(fileFilter);
        return fileFilter;
    }

    public static final boolean isRomFileName(File file) {
        String string = file.getName().toLowerCase();
        return string.endsWith(".bin") || string.endsWith(".img") || string.endsWith(".rom") || string.endsWith(".vec") || string.endsWith(".jverom");
    }

    public static final boolean isRomSourceFileName(File file) {
        String string = file.getName().toLowerCase();
        return string.endsWith(".asm") || string.endsWith(".a09") || string.endsWith(".s");
    }

    public static final boolean isRomFile(File file) {
        return UIGameSelector.isValidHeaderRomFile(file, true) || UIGameSelector.isValidHeaderDualBanksRomFile(file);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValidHeaderRomFile(File file, boolean bl) {
        boolean bl2;
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(file);
        long l = 0L;
        int n = 6;
        while (n-- > 0) {
            l = l << 8 | (long)((InputStream)fileInputStream).read();
        }
        boolean bl3 = bl2 = l == 113388332205344L || l == 81734390665037L && bl;
        if (fileInputStream == null) return bl2;
        try {
            ((InputStream)fileInputStream).close();
            return bl2;
        }
        catch (Exception exception) {}
        return bl2;
        catch (Exception exception) {
            try {
                if (fileInputStream == null) return false;
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
                return false;
            }
            catch (Exception exception3) {}
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final long getRomFileSize(File file) {
        if (!UIGameSelector.isValidHeaderRomFile(file, true)) return 0L;
        if (UIGameSelector.isValidHeaderRomFile(file, false)) {
            return file.length();
        }
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(file);
        ((InputStream)fileInputStream).skip(10L);
        int n = 0xFF & ~((InputStream)fileInputStream).read();
        int n2 = 0xFF & ~((InputStream)fileInputStream).read();
        int n3 = 0xFF & ~((InputStream)fileInputStream).read();
        long l = (((InputStream)fileInputStream).read() ^ n3) + ((((InputStream)fileInputStream).read() ^ n2) << 8) + ((((InputStream)fileInputStream).read() ^ n) << 16);
        if (fileInputStream == null) return l;
        try {
            ((InputStream)fileInputStream).close();
            return l;
        }
        catch (Exception exception) {}
        return l;
        catch (Exception exception) {
            try {
                if (fileInputStream == null) return 0L;
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
                return 0L;
            }
            catch (Exception exception3) {}
            return 0L;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isValidHeaderDualBanksRomFile(File file) {
        boolean bl;
        long l = file.length();
        if (l <= 32768L || l > 65536L) return false;
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(file);
        ((InputStream)fileInputStream).skip(32768L);
        boolean bl2 = bl = ((InputStream)fileInputStream).read() == 103 && ((InputStream)fileInputStream).read() == 32 && ((InputStream)fileInputStream).read() == 71 && ((InputStream)fileInputStream).read() == 67 && ((InputStream)fileInputStream).read() == 69;
        if (fileInputStream == null) return bl;
        try {
            ((InputStream)fileInputStream).close();
            return bl;
        }
        catch (Exception exception) {}
        return bl;
        catch (Exception exception) {
            try {
                if (fileInputStream == null) return false;
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
                return false;
            }
            catch (Exception exception3) {}
            return false;
        }
    }

    final class GamesComboBox
    extends JComboBox {
        GamesComboBox() {
            super(new Object[0]);
            this.setMaximumRowCount(20);
            this.setRenderer(new GamesComboBoxRenderer());
            this.addActionListener(new GamesComboBoxListener(this));
            this.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    GamesComboBox.this.setRenderer(new GamesComboBoxRenderer());
                }
            });
        }

        public CfgItemGame getSelectedGame() {
            CfgItemGameContainer cfgItemGameContainer = (CfgItemGameContainer)UIGameSelector.this.combo.getSelectedItem();
            return cfgItemGameContainer != null && cfgItemGameContainer.isGame() ? cfgItemGameContainer.game : null;
        }

        public void setSelectedGame(CfgItemGame cfgItemGame) {
            ComboBoxModel comboBoxModel = this.getModel();
            int n = comboBoxModel.getSize();
            while (n-- > 0) {
                CfgItemGameContainer cfgItemGameContainer = (CfgItemGameContainer)comboBoxModel.getElementAt(n);
                if (!cfgItemGameContainer.isGame() || !cfgItemGame.equals(cfgItemGameContainer.game)) continue;
                this.setSelectedIndex(n);
            }
        }

        protected void fireActionEvent() {
            super.fireActionEvent();
            super.fireActionEvent();
        }
    }

    final class GamesComboBoxListener
    implements ActionListener {
        private final JComboBox combo;
        private int lastSelIdx;

        GamesComboBoxListener(JComboBox jComboBox) {
            this.combo = jComboBox;
            this.lastSelIdx = jComboBox.getSelectedIndex();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CfgItemGameContainer cfgItemGameContainer = (CfgItemGameContainer)this.combo.getSelectedItem();
            if (cfgItemGameContainer.isSeparator() && this.lastSelIdx >= 0) {
                int n = this.combo.getSelectedIndex();
                if (((long)actionEvent.getModifiers() & 0x10L) != 0L) {
                    n = this.lastSelIdx;
                } else {
                    int n2 = this.combo.getModel().getSize() - 1;
                    n += n - this.lastSelIdx > 0 ? 1 : -1;
                    n = Math.min(n2, Math.max(0, n));
                    while (((CfgItemGameContainer)this.combo.getItemAt(n)).isSeparator()) {
                        ++n;
                    }
                }
                this.combo.setSelectedIndex(n);
            }
            this.lastSelIdx = this.combo.getSelectedIndex();
        }
    }

    final class GamesComboBoxRenderer
    extends DefaultListCellRenderer {
        private final Color SEP_COLOR = new Color(150, 150, 220);
        private final JComponent separator;
        private final JLabel sepLabel = new AALabel();
        private final JComponent sepLine = new JComponent(){

            public void paintChildren(Graphics graphics) {
                Insets insets = this.getInsets();
                int n = this.getWidth() - insets.left - insets.right;
                int n2 = this.getHeight() - insets.top - insets.bottom;
                graphics.fillRect(insets.left, insets.top + n2 / 2, n, 1);
            }
        };

        public GamesComboBoxRenderer() {
            this.separator = new JPanel(new BorderLayout(3, 0));
            this.separator.add((Component)this.sepLine, "Center");
            this.separator.add((Component)this.sepLabel, "East");
            this.separator.setBorder(new EmptyBorder(0, 3, 0, 4));
            this.separator.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                object = "";
            } else {
                CfgItemGameContainer cfgItemGameContainer = (CfgItemGameContainer)object;
                object = cfgItemGameContainer.toString();
                if (cfgItemGameContainer.isSeparator()) {
                    Color color = cfgItemGameContainer.separator.color;
                    if (color == null) {
                        color = this.SEP_COLOR;
                    }
                    this.sepLabel.setText(" " + object);
                    this.sepLabel.setForeground(color);
                    this.sepLine.setForeground(color);
                    return this.separator;
                }
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

